
#ifndef CustomLensflaresDef
#define CustomLensflaresDef

#define LfpActivateLog

typedef char bool;

typedef struct LfpFlares
{
	int Count;
	var Aura;
	var* Flares;
	MATERIAL* MatAura;
}LfpFlares;



typedef struct LfpLight
{
	ENTITY* Ent;
	//int Order;
	
	var Vertex;
	bool IsCreated;
	bool IsClipped;
	int MainGrpId;
	int SubGrpId;

	var InitialRadius;		// Cache the initial value for the range
	var Radius;					// Range of Skill5 for the Firty Flares, save original value
	bool IsSun;
	
	MATERIAL* MatAura;
	var Aura;

	LfpFlares* Sf;		// Normal lens flares
	LfpFlares* Df;		// Dirty Lens Flares

}LfpLight;

typedef struct LfpSubGroup
{
	int Id;
	char* Name;
	int Count;
	int LastOrderId;
	
	LfpLight* Lights;
}LfpSubGroup;

typedef struct LfpGroup
{
	int Id;
	char* Name;
	
	int Count;

	LfpSubGroup* Subs;

}LfpGroup;

typedef struct LfpStruct
{
	int GroupCount;
	int MaxLights;
	bool IsClipped;
	
	var SzHalfX; 			// Screensize * 0.5
	var SzHalfY;			// Screensize * 0.5
	
	var* DfScalesX;
	var* DfSizesX;
	var* DfSizesY;
	
	LfpGroup* Groups;		// Lighting groups
	
}LfpStruct;


LfpStruct* Lfp = NULL;








/* Determines the position of the lens flares or dusts from the center of the screen (value 1) up or down.
Negative values go down */
#define LfpPivotDist skill1

/* Additional values for moving view entities on the X or Y axis  */
#define LfpAxisRl skill2
#define LfpAxisUd skill3
#define LfpMaxAlpha skill4

/* Stores the value of the last alpha */
#define LfpTemp1 skill5
#define LfpTemp2 skill6
#define LfpTemp3 skill7

/* Also move the pivot on the X / Y axis */
#define LfpAxisPdRl skill8
#define LfpAxisPdUd skill9

/* XY position of the flares when the camera is moved (required for the lens dust effects) */
#define LfpMidPosX skill60
#define LfpMidPosY skill61

/* XYZ position of the light (the model with the action)*/
#define LfpPosX skill70
#define LfpPosY skill71
#define LfpPosZ skill72

#define LfpVisAlpha skill90	
#define LfpId skill98			// An ID is assigned to each light, which is also an array index
#define LfpTracePos skill100	// Distance to light by trace





/* WED Skills */
#define LfpLightDist skill1		// Distance to the model. The sun is always 100.
#define LfpBlue skill2				// Red, green, blue coloring of the light
#define LfpGreen skill3
#define LfpRed skill4
#define LfpRadius skill5			// Radius of light in which flares can be seen
#define LfpMaxDustAlpha skill6	// Maximum alpha of the dust flares
#define LfpMaxLightAlpha skill7	// Maximum alpha of the lights themselves
#define LfpOrderId skill8			// Sequence of lights with the same group
#define LfpMaxAuraAlpha skill9	// Maximum alpha of the light aura (should be smaller than LfpMaxDustAlpha. The more lights are together, the smaller the value)
#define LfpLightDistCtrl skill11 // Controls the appearance of the flares a bit more precisely by multiplying with this skill

#define LfpHasDirtyFlares FLAG8





/* View-Ent-Mode */
#define LfpModeD 0 	// Place the view ent in the middle
#define LfpModeX 1 	// Places the view ents in X mode (additional X movement)
#define LfpModeXY 2 	// Places the view ents in XY mode (additional XY movement)
#define LfpModeXYP 3	// Places the view ents in normal mode (XY axis movement + pivot + half screen length)


/* Lighting groups */
#define LfpLTypeLong 1
	#define LfpNeonPipe1 1
	#define LfpNeonPipe2 2
	#define LfpNeonPipe3 3

#define LfpLTypePoint 2
	#define LfpSun1 2
	#define LfpSun2 3
	#define LfpLamp1 4
	
#define LfpLTypeWindow 3
	#define LfpWindowRed 1
	#define LfpWindowWhite 2





// Helper
MATERIAL* LfpMatCreate(int pow, var* spec, var* diff, var* amb);

// Initialization & Cleanup
int LfpGetGrpId(ENTITY* ent, char* string1, char* string2, bool isSubGrp);
char* LfpGetGrpText(int id, bool isSubGrp);
int LfpGrpExist(LfpGroup* lfpGrps, int count, int id);
int LfpSubGrpExist(LfpGroup* lfpGrps, int index, int id);
void LfpAddLight(ENTITY* et, char* mainGroup, char* subGroup, var vertexNum);
void LfpAddLight(ENTITY* et, var vertexNum);
void LfpAddLight(ENTITY* et);
void LfpInitialize(ENTITY** ents, int count);
void LfpInitialize();
void LfpStartLights();
void LfpCleanUp();

// Dust & Dirty
void LfpCtrlDirtyFlares(LfpLight* light);
var* LfpCreateDirtyFlares(LfpLight* light);
void LfpDeleteDirtyFlares(LfpLight* light);

// Flare-control
void LfpCtrlLightsGrpPointAdd1(ENTITY* ent, ENTITY* entFlare, int index, var val1, var val2);
void LfpCtrlLightsGrpPointAdd2(ENTITY* ent, ENTITY* entFlare, int index, var val1, var val2);
void LfpPlace(ENTITY* ent, var* pos, var mode);
void LfpSetLightFlareColor(var* src, LfpLight* light, var* colors);
var LfpCreateLightFlare(char* name, var layer, var pd, var* scale, var axisPdRl, var axisPdUd);
void LfpDeleteLightFlares(LfpLight* light);
var* LfpCreateLightFlares(LfpLight* light);
void LfpPlaceLightFlare(ENTITY* ent, ENTITY* entFlare, int mainId, int subId, int index);
void LfpControlLightFlare(ENTITY* ent, ENTITY* entFlare,int mainId, int subId, int index);
void LfpAlphaLightFlare(ENTITY* ent, ENTITY* entFlare,int mainId, int subId, int index);
void LfpControlAllLightFlareEffects(LfpLight* light, bool blendOut);

// Aura
void LfpControlLightAuras(LfpLight* light);
ENTITY* LfpCreateLightAura(LfpLight* light,var layer, char* name);
ENTITY* LfpCreateLightAura(LfpLight* light);
void LfpSetLightAuraMaterial(LfpLight* light);

// Lights
void LfpControlLightBlending(LfpLight* light, var dist);
void LfpControlLights(LfpLight* light, var dist);
void LfpSetLightMaterial(LfpLight* light);
void LfpSetLightParent(LfpLight* light);
void LfpDeleteLightResources(LfpLight* light);
void LfpCreateLight(LfpLight* light);


#endif